-- Gilchrist


set sql_safe_updates=0;

-- Offer Letter Doc

SET @offerletr=(SELECT id FROM dydt_data_provider WHERE `providerName`='OFFER_LETTER_INFO');
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT 
                ap.firstName AS applicant_firstname,
                ap.lastName AS applicant_lastname,
                ap.middleName AS applicant_middlename,
                ap.gender AS applicant_gender,
                ap.printName AS applicant_printname,
                a.code AS application_code,
                s.salutationName AS applicant_salutation,
                s.salutationNameInOtherLanguage AS applicant_salutation_otr_lang,
                ap.birthDate AS birth_date,
                ap.photoUrl AS app_photo_url
            FROM
                application a
                    LEFT JOIN
                applicant_person ap ON a.applicantPersonId = ap.id
                    LEFT JOIN
                salutations s ON ap.salutationId = s.id',
    `resultColumnsDef` = 'applicant_firstname,applicant_lastname,applicant_middlename,applicant_gender,applicant_printname,applicant_salutation_otr_lang,application_code,applicant_salutation,birth_date,app_photo_url'
WHERE
        `whetherPrimaryDataSource` = '1'
        AND `executionOrder` = '3'
        AND `whetherDataSource` = '1'
        AND `dataProviderId` = @offerletr;

        
SET @offerletr=(SELECT id FROM dydt_data_provider WHERE `providerName`='OFFER_LETTER_INFO');
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT 
        p.programCode AS program_code,
        p.programName AS program_name,
        p.programNameToBePrint AS program_print_name,
        p.programNameToBePrintLanguageOne AS program_print_name_afr,
        pd.shortCode AS primary_dept_code,
        pd.deptName AS primary_dept_name,
        psd.shortCode AS secondary_dept_code,
        psd.deptName AS secondary_dept_name,
        b.batchName AS batch_name,
        b.startDate AS batch_start_date,
        b.tillDate AS batch_tilldate,
        pg.groupName AS program_group_name
    FROM
        application_program aprgm
            LEFT JOIN
        programs p ON aprgm.programId = p.id
            LEFT JOIN
        prog_batch_seat_config pbsc ON aprgm.progBatchSeatConfigId = pbsc.id
            LEFT JOIN
        batches b ON b.id = pbsc.programBatchId
            LEFT JOIN
        department pd ON pd.id = p.programDepartmentId
            LEFT JOIN
        department psd ON psd.id = p.subDepartmentId
    		LEFT JOIN
       program_group pg ON pg.id = p.programGroupId',
    `resultColumnsDef` = 'program_code,program_name,program_print_name,program_print_name_afr,primary_dept_code,primary_dept_name,secondary_dept_code,secondary_dept_name, batch_name, batch_start_date,batch_end_date,batch_tilldate,program_group_name'
WHERE
        `whetherPrimaryDataSource` = '1'
        AND `executionOrder` = '2'
        AND `whetherDataSource` = '1'
        AND `dataProviderId` = @offerletr;

 
 set sql_safe_updates=1;